/*
 * Decompiled with CFR 0.152.
 */
package org.expasy.bprg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.expasy.bprg.PeptideLabel;
import org.expasy.bprg.PhenyxSILACPeptide;
import org.expasy.bprg.SilacQuantiParam;

public class PeptideQuantiInfos {
    private static Logger log = Logger.getLogger(PeptideQuantiInfos.class);
    private String proteinName;
    private String peptideString;
    private int labeledAANumber;
    private String form;
    private String masses;
    private double lightMass;
    private double c12Areas = 0.0;
    private double heavyMass;
    private double[] c13Areas = new double[3];
    private double[] intermMasses;
    private double[][] intermAreas;
    private SilacQuantiParam quantiParams;
    private boolean fileFound = true;

    public void collectInfos(PhenyxSILACPeptide phenyxSILACPeptide, SilacQuantiParam silacQuantiParam) {
        this.quantiParams = silacQuantiParam;
        if (this.quantiParams.data.size() == 1) {
            this.collectInfos1Label(phenyxSILACPeptide, this.quantiParams.data.get(0));
        } else {
            this.collectInfosMultiLabels(phenyxSILACPeptide, silacQuantiParam);
        }
    }

    private void collectInfos1Label(PhenyxSILACPeptide phenyxSILACPeptide, PeptideLabel peptideLabel) {
        this.proteinName = phenyxSILACPeptide.getProteinName();
        this.peptideString = phenyxSILACPeptide.getPeptideString();
        this.labeledAANumber = phenyxSILACPeptide.getAACount(new char[]{peptideLabel.aminoacid.charAt(0)});
        double d = phenyxSILACPeptide.getPeptideMass();
        boolean bl = phenyxSILACPeptide.isLabeledWith(peptideLabel.label);
        double d2 = bl ? d - (double)(this.labeledAANumber * peptideLabel.shift) : d;
        double d3 = bl ? d : d + (double)(this.labeledAANumber * peptideLabel.shift);
        this.form = bl ? peptideLabel.label : "Normal";
        String string = phenyxSILACPeptide.getSpectrumId();
        double[][] dArray = this.loadFile(string);
        if (dArray == null) {
            this.masses = "Label: " + string + " : file not found.";
            this.fileFound = false;
        } else {
            this.findPA(dArray, d2, d3, this.labeledAANumber);
            String string2 = phenyxSILACPeptide.getSpectrumLabel() + this.getModifsAsStrExceptLabel(phenyxSILACPeptide, peptideLabel.label);
            string2 = string2 + "/" + (this.lightMass == 0.0 ? "?" : "" + this.lightMass);
            string2 = string2 + "/" + (this.heavyMass == 0.0 ? "?" : "" + this.heavyMass);
            if (this.intermMasses != null) {
                for (int i = 0; i < this.intermMasses.length; ++i) {
                    string2 = string2 + "/" + (this.intermMasses[i] == 0.0 ? "?" : "" + this.intermMasses[i]);
                }
            }
            this.masses = string2;
        }
    }

    private void collectInfosMultiLabels(PhenyxSILACPeptide phenyxSILACPeptide, SilacQuantiParam silacQuantiParam) {
        int n = phenyxSILACPeptide.getAAPresent(silacQuantiParam.getAALabels());
        if (n == 0) {
            return;
        }
        if (n == 1) {
            int n2;
            int[] nArray = phenyxSILACPeptide.getAACounts(silacQuantiParam.getAALabels());
            for (n2 = 0; n2 < nArray.length && nArray[n2] == 0; ++n2) {
            }
            this.collectInfos1Label(phenyxSILACPeptide, silacQuantiParam.data.get(n2));
        } else {
            double d;
            double d2;
            boolean[] blArray = phenyxSILACPeptide.isLabeledWith(silacQuantiParam.getTagLabels());
            String string = Arrays.toString(blArray);
            if (string.contains("true") && string.contains("false")) {
                return;
            }
            double d3 = phenyxSILACPeptide.getPeptideMass();
            this.proteinName = phenyxSILACPeptide.getProteinName();
            this.peptideString = phenyxSILACPeptide.getPeptideString();
            this.labeledAANumber = phenyxSILACPeptide.getAACount(silacQuantiParam.getAALabels());
            int[] nArray = phenyxSILACPeptide.getAACounts(silacQuantiParam.getAALabels());
            double d4 = 0.0;
            int n3 = 0;
            for (PeptideLabel peptideLabel : silacQuantiParam.data) {
                d4 += (double)(peptideLabel.shift * nArray[n3]);
                ++n3;
            }
            if (Arrays.equals(blArray, new boolean[blArray.length])) {
                this.form = "Normal";
                d2 = d3;
                d = d3 + d4;
            } else {
                this.form = Arrays.toString(silacQuantiParam.getTagLabels());
                d2 = d3 - d4;
                d = d3;
            }
            String string2 = phenyxSILACPeptide.getSpectrumId();
            double[][] dArray = this.loadFile(string2);
            if (dArray == null) {
                this.masses = "Label: " + string2 + " : file not found.";
                this.fileFound = false;
            } else {
                this.findPA(dArray, d2, d, this.labeledAANumber);
                String string3 = phenyxSILACPeptide.getSpectrumLabel() + this.getModifsAsStrExceptLabel(phenyxSILACPeptide, silacQuantiParam.getTagLabels());
                string3 = string3 + "/" + (this.lightMass == 0.0 ? "?" : "" + this.lightMass);
                this.masses = string3 = string3 + "/" + (this.heavyMass == 0.0 ? "?" : "" + this.heavyMass);
            }
        }
    }

    private String getModifsAsStrExceptLabel(PhenyxSILACPeptide phenyxSILACPeptide, String string) {
        String string2 = "/";
        boolean bl = false;
        Iterable<String> iterable = phenyxSILACPeptide.getModifsExcept(string);
        for (String string3 : iterable) {
            string2 = string2 + string3;
            bl = true;
        }
        return bl ? string2 : "";
    }

    private String getModifsAsStrExceptLabel(PhenyxSILACPeptide phenyxSILACPeptide, String[] stringArray) {
        String string = "/";
        boolean bl = false;
        Iterable<String> iterable = phenyxSILACPeptide.getModifsExcept(stringArray);
        for (String string2 : iterable) {
            string = string + string2;
            bl = true;
        }
        return bl ? string : "";
    }

    private void findPA(double[][] dArray, double d, double d2, int n) {
        int n2;
        int n3;
        log.debug("Trying to find masses " + d + " and " + d2);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (!(d - this.quantiParams.error <= dArray[n3][0]) || !(dArray[n3][0] <= d + this.quantiParams.error)) continue;
            this.lightMass = dArray[n3][0];
            this.c12Areas = dArray[n3][1];
            log.debug("Found mass C12 : " + this.lightMass + " and pa : " + this.c12Areas);
            break;
        }
        if (n3 >= dArray.length) {
            n3 = 0;
        }
        boolean bl = false;
        for (n2 = n3; n2 < dArray.length; ++n2) {
            if (!(d2 - this.quantiParams.error < dArray[n2][0]) || !(dArray[n2][0] < d2 + this.quantiParams.error)) continue;
            this.heavyMass = dArray[n2][0];
            this.c13Areas[0] = dArray[n2][1];
            bl = true;
            log.debug("Found mass C13 : " + this.heavyMass + " and pa : " + this.c13Areas[0]);
            if (n == 1) {
                this.c13Areas[1] = -1.0;
                this.c13Areas[2] = -1.0;
            }
            if (n == 2) {
                this.c13Areas[2] = -1.0;
            }
            if (this.quantiParams.findEchoPeaks < 1 || n <= 1 || n2 <= 0 || !(d2 - 1.0 - this.quantiParams.error <= dArray[n2 - 1][0]) || !(dArray[n2 - 1][0] <= d2 - 1.0 + this.quantiParams.error)) break;
            this.c13Areas[1] = dArray[n2 - 1][1];
            log.debug("Found pa for mass C13-1Da : " + this.c13Areas[1]);
            if (this.quantiParams.findEchoPeaks != 2 || n <= 2 || n2 <= 1 || !(d2 - 2.0 - this.quantiParams.error <= dArray[n2 - 2][0]) || !(dArray[n2 - 2][0] <= d2 - 2.0 + this.quantiParams.error)) break;
            this.c13Areas[2] = dArray[n2 - 2][1];
            log.debug("Found pa for mass C13-2Da : " + this.c13Areas[2]);
            break;
        }
        if (this.quantiParams.findIntermPeaks && bl) {
            this.intermMasses = new double[n - 1];
            this.intermAreas = new double[n - 1][3];
            block2: for (n2 = 1; n2 < n; ++n2) {
                double d3 = d + (double)(n2 * this.quantiParams.data.get((int)0).shift);
                while (n3 < dArray.length) {
                    if (d3 - this.quantiParams.error <= dArray[n3][0] && dArray[n3][0] <= d3 + this.quantiParams.error) {
                        this.intermMasses[this.intermMasses.length - n2] = dArray[n3][0];
                        this.intermAreas[this.intermAreas.length - n2][0] = dArray[n3][1];
                        log.debug("Found mass " + d3 + " : " + this.intermMasses[this.intermMasses.length - n2] + " and pa : " + this.intermAreas[this.intermAreas.length - n2][0]);
                        if (this.quantiParams.findEchoPeaks < 1 || n3 <= 0 || !(d3 - 1.0 - this.quantiParams.error <= dArray[n3 - 1][0]) || !(dArray[n3 - 1][0] <= d3 - 1.0 + this.quantiParams.error)) continue block2;
                        this.intermAreas[this.intermAreas.length - n2][1] = dArray[n3 - 1][1];
                        log.debug("Found pa for mass " + d3 + "-1Da : " + this.intermAreas[this.intermAreas.length - n2][1]);
                        if (this.quantiParams.findEchoPeaks != 2 || n3 <= 1 || !(d3 - 2.0 - this.quantiParams.error <= dArray[n3 - 2][0]) || !(dArray[n3 - 2][0] <= d3 - 2.0 + this.quantiParams.error)) continue block2;
                        this.intermAreas[this.intermAreas.length - n2][2] = dArray[n3 - 2][1];
                        log.debug("Found pa for mass " + d3 + "-2Da : " + this.intermAreas[this.intermAreas.length - n2][2]);
                        continue block2;
                    }
                    ++n3;
                }
            }
        }
    }

    private double[][] loadFile(String string) {
        log.debug("Loading label " + string + " in folder " + this.quantiParams.paFolder + " with file filter " + this.quantiParams.paFilter);
        if (this.quantiParams.paFolder.isDirectory()) {
            int n;
            File[] fileArray = this.quantiParams.paFolder.listFiles();
            for (n = 0; n < fileArray.length && !fileArray[n].getName().startsWith(this.quantiParams.paFilter + string + "_"); ++n) {
            }
            if (n != fileArray.length) {
                File file = fileArray[n];
                log.debug("Found file " + file);
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    bufferedReader.readLine();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string2 = "";
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.length() == 0) continue;
                        arrayList.add(string2);
                    }
                    arrayList.trimToSize();
                    double[][] dArray = new double[arrayList.size()][2];
                    int n2 = 0;
                    for (String string3 : arrayList) {
                        String[] stringArray = string3.split("\t");
                        dArray[n2][0] = new Double(stringArray[0]);
                        dArray[n2][1] = new Double(stringArray[1]);
                        ++n2;
                    }
                    return dArray;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public double getSumLightForms() {
        double d = this.c12Areas;
        return d;
    }

    public double getSumHeavyForms() {
        double d = this.c13Areas[0];
        d += this.c13Areas[1];
        d += this.c13Areas[2];
        if (this.intermAreas != null) {
            for (int i = 0; i < this.intermAreas.length; ++i) {
                d += this.intermAreas[i][0];
                d += this.intermAreas[i][1];
                d += this.intermAreas[i][2];
            }
        }
        return d;
    }

    public String getMasses() {
        return this.masses;
    }

    public String getForm() {
        return this.form;
    }

    public int getLabeledAANumber() {
        return this.labeledAANumber;
    }

    public String getPeptideString() {
        return this.peptideString;
    }

    public String getProteinName() {
        return this.proteinName;
    }

    public double getC12Areas() {
        return this.c12Areas;
    }

    public double[] getC13Areas() {
        return this.c13Areas;
    }

    public double getHeavyMass() {
        return this.heavyMass;
    }

    public double[][] getIntermAreas() {
        return this.intermAreas;
    }

    public double[] getIntermMasses() {
        return this.intermMasses;
    }

    public double getLightMass() {
        return this.lightMass;
    }

    public boolean isFileFound() {
        return this.fileFound;
    }
}

