/*
 * Decompiled with CFR 0.152.
 */
package org.expasy.bprg;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import jxl.Cell;
import jxl.CellType;
import jxl.NumberCell;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.log4j.Logger;
import org.expasy.bprg.PeptideQuantiInfos;
import org.expasy.bprg.PhenyxSILACPeptide;
import org.expasy.bprg.SilacQuantiParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilacQuanti {
    private static Logger log = Logger.getLogger(SilacQuanti.class);
    private static final int PROTEIN_COLUMN = 0;
    private static final int PEPTIDESTR_COLUMN = 1;
    private static final int NBLABELEDAA_COLUMN = 2;
    private static final int FOUNDFORMS_COLUMN = 3;
    private static final int MASSES_COLUMN = 4;
    private static final int C12INTENSITY_COLUMN = 5;
    private static int SUMC12_COLUMN = -1;
    private static int SUMC13_COLUMN = -1;
    private static int RATIO_COLUMN = -1;
    private WritableCellFormat orangeformat;
    private WritableCellFormat redformat;
    private WritableCellFormat boldformat;
    private WritableCellFormat twodpsFormat;
    private SilacQuantiParam quantiParams;

    public SilacQuanti() {
        this.initCellFormats();
    }

    public boolean quantifyAndWrite(File file, SilacQuantiParam silacQuantiParam) {
        this.quantiParams = silacQuantiParam;
        Workbook workbook = null;
        WritableWorkbook writableWorkbook = null;
        try {
            workbook = Workbook.getWorkbook(file);
            File file2 = new File(file.getParentFile(), "quanti_" + file.getName());
            writableWorkbook = Workbook.createWorkbook(file2, workbook);
            this.computeQuantification(writableWorkbook);
            writableWorkbook.write();
            writableWorkbook.close();
            workbook.close();
            File file3 = new File(System.getProperty("user.home"));
            if (file3.exists() && file3.isDirectory()) {
                File[] fileArray = file3.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.equals("maldipepquant.txt");
                    }
                });
                if (fileArray.length == 1) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[0]));
                    File file4 = new File(bufferedReader.readLine());
                    if (file4.exists() && file4.isFile() && file4.getName().equalsIgnoreCase("excel.exe")) {
                        JOptionPane.showMessageDialog(null, "Done!\n Opening :" + file2.getCanonicalPath());
                        Runtime.getRuntime().exec("\"" + file4.getCanonicalPath() + "\" \"" + file2.getPath() + "\"");
                    } else {
                        JOptionPane.showMessageDialog(null, "Done!\n See :" + file2.getCanonicalPath() + "\n\n (But I could also open the resulting file for you\nif you put a small file named \"maldipepquant.txt\"\ncontaining the full path to the Excel executable\nin your home folder...)");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Done!\n See :" + file2.getCanonicalPath() + "\n\n (But I could also open the resulting file for you\nif you put a small file named \"maldipepquant.txt\"\ncontaining the full path to the Excel executable\nin your home folder...)");
                }
            }
        }
        catch (BiffException biffException) {
            biffException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error : " + biffException.getMessage(), "Excel error", 0);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error : " + iOException.getMessage(), "File error", 0);
            return false;
        }
        catch (WriteException writeException) {
            writeException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error : " + writeException.getMessage(), "Write error", 0);
            return false;
        }
        return true;
    }

    private void initCellFormats() {
        NumberFormat numberFormat = new NumberFormat("###,##0.##");
        this.twodpsFormat = new WritableCellFormat(numberFormat);
        WritableFont writableFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED);
        this.redformat = new WritableCellFormat(writableFont, (DisplayFormat)numberFormat);
        WritableFont writableFont2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.ORANGE);
        this.orangeformat = new WritableCellFormat(writableFont2, (DisplayFormat)numberFormat);
        WritableFont writableFont3 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        this.boldformat = new WritableCellFormat(writableFont3);
    }

    private void computeQuantification(WritableWorkbook writableWorkbook) {
        WritableSheet writableSheet = writableWorkbook.getSheet(0);
        WritableSheet writableSheet2 = null;
        int n = 0;
        ArrayList<PeptideQuantiInfos> arrayList = new ArrayList<PeptideQuantiInfos>();
        for (int i = 1; i < writableSheet.getRows() && writableSheet.getCell(0, i).getType() != CellType.EMPTY; ++i) {
            PhenyxSILACPeptide phenyxSILACPeptide;
            int n2;
            int n3 = (int)((NumberCell)writableSheet.getCell(0, i)).getValue();
            if (n3 != n) {
                if (writableSheet2 != null) {
                    this.writeQuantiInfos(writableSheet2, arrayList);
                    this.postprocess(writableSheet2);
                }
                writableSheet2 = writableWorkbook.createSheet("" + n3, 0);
                writableSheet2.getSettings().setVerticalFreeze(1);
                if (this.quantiParams.data.size() == 1) {
                    this.initDisplay1(writableSheet, writableSheet2);
                } else {
                    this.initDisplay2(writableSheet, writableSheet2);
                }
                n = n3;
            }
            if ((n2 = (phenyxSILACPeptide = new PhenyxSILACPeptide(writableSheet.getRow(i))).getAAPresent(this.quantiParams.getAALabels())) == 0) continue;
            PeptideQuantiInfos peptideQuantiInfos = new PeptideQuantiInfos();
            peptideQuantiInfos.collectInfos(phenyxSILACPeptide, this.quantiParams);
            if (peptideQuantiInfos.getProteinName() == null) continue;
            arrayList.add(peptideQuantiInfos);
        }
        if (writableSheet2 != null) {
            this.writeQuantiInfos(writableSheet2, arrayList);
            this.postprocess(writableSheet2);
        }
    }

    private void writeQuantiInfos(WritableSheet writableSheet, ArrayList<PeptideQuantiInfos> arrayList) {
        int n = 1;
        for (PeptideQuantiInfos peptideQuantiInfos : arrayList) {
            this.addLabelToSheet(writableSheet, 0, n, peptideQuantiInfos.getProteinName(), null);
            this.addLabelToSheet(writableSheet, 1, n, peptideQuantiInfos.getPeptideString(), null);
            this.addNumberToSheet(writableSheet, 2, n, peptideQuantiInfos.getLabeledAANumber(), null);
            this.addLabelToSheet(writableSheet, 3, n, peptideQuantiInfos.getForm(), null);
            this.addLabelToSheet(writableSheet, 4, n, peptideQuantiInfos.getMasses(), null);
            if (peptideQuantiInfos.isFileFound()) {
                double[][] dArray;
                int n2 = 5;
                double d = peptideQuantiInfos.getC12Areas();
                this.addDoubleToSheet(writableSheet, n2, n, d, this.twodpsFormat);
                double[] dArray2 = peptideQuantiInfos.getC13Areas();
                this.addDoubleToSheet(writableSheet, ++n2, n, dArray2[0], this.twodpsFormat);
                ++n2;
                if (this.quantiParams.findEchoPeaks >= 1) {
                    this.addDoubleToSheet(writableSheet, n2, n, dArray2[1], dArray2[1] > dArray2[0] ? this.orangeformat : this.twodpsFormat);
                    ++n2;
                    if (this.quantiParams.findEchoPeaks == 2) {
                        this.addDoubleToSheet(writableSheet, n2, n, dArray2[2], dArray2[2] > dArray2[1] ? this.orangeformat : this.twodpsFormat);
                        ++n2;
                    }
                }
                if ((dArray = peptideQuantiInfos.getIntermAreas()) != null) {
                    for (int i = 0; i < dArray.length; ++i) {
                        this.addDoubleToSheet(writableSheet, n2, n, dArray[i][0], dArray[i][0] > dArray2[0] ? this.redformat : this.twodpsFormat);
                        ++n2;
                        if (this.quantiParams.findEchoPeaks < 1) continue;
                        this.addDoubleToSheet(writableSheet, n2, n, dArray[i][1], dArray[i][1] > dArray[i][0] ? this.orangeformat : this.twodpsFormat);
                        ++n2;
                        if (this.quantiParams.findEchoPeaks != 2) continue;
                        this.addDoubleToSheet(writableSheet, n2, n, dArray[i][2], dArray[i][2] > dArray[i][1] ? this.orangeformat : this.twodpsFormat);
                        ++n2;
                    }
                }
                double d2 = peptideQuantiInfos.getSumLightForms();
                double d3 = peptideQuantiInfos.getSumHeavyForms();
                this.addDoubleToSheet(writableSheet, SUMC12_COLUMN, n, d2, this.twodpsFormat);
                this.addDoubleToSheet(writableSheet, SUMC13_COLUMN, n, d3, this.twodpsFormat);
                if (d3 != 0.0) {
                    this.addDoubleToSheet(writableSheet, RATIO_COLUMN, n, d2 / d3, null);
                } else {
                    this.addLabelToSheet(writableSheet, RATIO_COLUMN, n, "Division par 0", null);
                }
            }
            ++n;
        }
    }

    private void postprocess(WritableSheet writableSheet) {
        this.mergeSimilarLines(writableSheet);
        this.autoFit(writableSheet);
    }

    private void mergeSimilarLines(WritableSheet writableSheet) {
        log.debug("Merging similar lines...");
        for (int i = 1; i < writableSheet.getRows(); ++i) {
            String string = writableSheet.getCell(0, i).getContents();
            if (string.equals("")) continue;
            String string2 = writableSheet.getCell(1, i).getContents();
            String string3 = writableSheet.getCell(4, i).getContents();
            for (int j = i + 1; j < writableSheet.getRows(); ++j) {
                String string4;
                String string5 = writableSheet.getCell(0, j).getContents();
                if (string5.equals("")) continue;
                String string6 = writableSheet.getCell(1, j).getContents();
                String string7 = writableSheet.getCell(4, j).getContents();
                if (!string.equals(string5) || !string2.equals(string6) || !string3.equals(string7)) continue;
                String string8 = writableSheet.getCell(3, i).getContents();
                String string9 = string8.compareTo(string4 = writableSheet.getCell(3, j).getContents()) < 0 ? string8 + "+" + string4 : string4 + "+" + string8;
                this.addLabelToSheet(writableSheet, 3, i, string9, null);
                writableSheet.removeRow(j);
            }
        }
    }

    private void autoFit(WritableSheet writableSheet) {
        FontMetrics fontMetrics = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics2D graphics2D = graphicsEnvironment.createGraphics(bufferedImage);
        for (int i = 0; i < writableSheet.getColumns(); ++i) {
            int n = 0;
            int n2 = 0;
            for (int j = 0; j < writableSheet.getRows(); ++j) {
                Cell cell = writableSheet.getCell(i, j);
                if (cell.getContents() == "") continue;
                jxl.format.Font font = cell.getCellFormat().getFont();
                int n3 = font.getBoldWeight() == 1 ? 1 : 0;
                Font font2 = new Font(font.getName(), n3, font.getPointSize());
                fontMetrics = graphics2D.getFontMetrics(font2);
                n2 = fontMetrics.stringWidth(cell.getContents());
                if (n2 <= n) continue;
                n = n2;
            }
            if ((n = (int)Math.ceil((double)n * 1.5)) <= 0) continue;
            writableSheet.setColumnView(i, (int)Math.ceil((n - 5) / 7));
        }
    }

    private void initDisplay1(WritableSheet writableSheet, WritableSheet writableSheet2) {
        int n = this.computeMaxAACounter(writableSheet, this.quantiParams.data.get((int)0).aminoacid.charAt(0));
        SUMC12_COLUMN = 5 + (1 + (this.quantiParams.findIntermPeaks ? n - 1 : 0)) * (this.quantiParams.findEchoPeaks + 1) + 1;
        SUMC13_COLUMN = SUMC12_COLUMN + 1;
        RATIO_COLUMN = SUMC12_COLUMN + 2;
        this.addHeaders1(writableSheet2, n);
    }

    private void initDisplay2(WritableSheet writableSheet, WritableSheet writableSheet2) {
        SUMC12_COLUMN = 5 + (this.quantiParams.findEchoPeaks + 1) + 1;
        SUMC13_COLUMN = SUMC12_COLUMN + 1;
        RATIO_COLUMN = SUMC12_COLUMN + 2;
        this.addHeaders2(writableSheet2);
    }

    private int computeMaxAACounter(WritableSheet writableSheet, char c) {
        int n = 0;
        for (int i = 1; i < writableSheet.getRows(); ++i) {
            Cell cell = writableSheet.getCell(2, i);
            String string = cell.getContents();
            int n2 = 0;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != c) continue;
                ++n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void addHeaders1(WritableSheet writableSheet, int n) {
        this.addLabelToSheet(writableSheet, 0, 0, "Proteines", this.boldformat);
        this.addLabelToSheet(writableSheet, 1, 0, "Peptides", this.boldformat);
        this.addLabelToSheet(writableSheet, 2, 0, "Labeled AA nb", this.boldformat);
        this.addLabelToSheet(writableSheet, 3, 0, "Forms", this.boldformat);
        this.addLabelToSheet(writableSheet, 4, 0, "Masses", this.boldformat);
        int n2 = 5;
        this.addLabelToSheet(writableSheet, n2, 0, "Light Form", this.boldformat);
        this.addLabelToSheet(writableSheet, ++n2, 0, "Heavy Form", this.boldformat);
        if (this.quantiParams.findEchoPeaks >= 1) {
            this.addLabelToSheet(writableSheet, ++n2, 0, "HF -1Da", this.boldformat);
        }
        if (this.quantiParams.findEchoPeaks == 2) {
            this.addLabelToSheet(writableSheet, ++n2, 0, "HF -2Da", this.boldformat);
        }
        if (this.quantiParams.findIntermPeaks) {
            int n3;
            for (int i = n3 = this.quantiParams.data.get((int)0).shift.intValue(); n2 < SUMC12_COLUMN - 1 && i < n * n3; i += n3) {
                this.addLabelToSheet(writableSheet, ++n2, 0, "HF -" + i + "Da", this.boldformat);
                if (this.quantiParams.findEchoPeaks >= 1) {
                    this.addLabelToSheet(writableSheet, ++n2, 0, "HF -" + i + "-1Da", this.boldformat);
                }
                if (this.quantiParams.findEchoPeaks != 2) continue;
                this.addLabelToSheet(writableSheet, ++n2, 0, "HF -" + i + "-2Da", this.boldformat);
            }
        }
        this.addLabelToSheet(writableSheet, SUMC12_COLUMN, 0, "Sum LF", this.boldformat);
        this.addLabelToSheet(writableSheet, SUMC13_COLUMN, 0, "Sum HF", this.boldformat);
        this.addLabelToSheet(writableSheet, RATIO_COLUMN, 0, "LF / HF", this.boldformat);
    }

    private void addHeaders2(WritableSheet writableSheet) {
        this.addLabelToSheet(writableSheet, 0, 0, "Proteines", this.boldformat);
        this.addLabelToSheet(writableSheet, 1, 0, "Peptides", this.boldformat);
        this.addLabelToSheet(writableSheet, 2, 0, "Labeled AA nb", this.boldformat);
        this.addLabelToSheet(writableSheet, 3, 0, "Forms", this.boldformat);
        this.addLabelToSheet(writableSheet, 4, 0, "Masses", this.boldformat);
        int n = 5;
        this.addLabelToSheet(writableSheet, n, 0, "Light Form", this.boldformat);
        this.addLabelToSheet(writableSheet, ++n, 0, "Heavy Form", this.boldformat);
        if (this.quantiParams.findEchoPeaks >= 1) {
            this.addLabelToSheet(writableSheet, ++n, 0, "HF -1Da", this.boldformat);
        }
        if (this.quantiParams.findEchoPeaks == 2) {
            this.addLabelToSheet(writableSheet, ++n, 0, "HF -2Da", this.boldformat);
        }
        this.addLabelToSheet(writableSheet, SUMC12_COLUMN, 0, "Sum LF", this.boldformat);
        this.addLabelToSheet(writableSheet, SUMC13_COLUMN, 0, "Sum HF", this.boldformat);
        this.addLabelToSheet(writableSheet, RATIO_COLUMN, 0, "LF / HF", this.boldformat);
    }

    private void addLabelToSheet(WritableSheet writableSheet, int n, int n2, String string, WritableCellFormat writableCellFormat) {
        try {
            if (writableCellFormat == null) {
                writableSheet.addCell(new Label(n, n2, string));
            } else {
                writableSheet.addCell(new Label(n, n2, string, (CellFormat)writableCellFormat));
            }
        }
        catch (RowsExceededException rowsExceededException) {
            rowsExceededException.printStackTrace();
        }
        catch (WriteException writeException) {
            writeException.printStackTrace();
        }
    }

    private void addNumberToSheet(WritableSheet writableSheet, int n, int n2, int n3, WritableCellFormat writableCellFormat) {
        try {
            if (writableCellFormat == null) {
                writableSheet.addCell(new Number(n, n2, (double)n3));
            } else {
                writableSheet.addCell(new Number(n, n2, (double)n3, (CellFormat)writableCellFormat));
            }
        }
        catch (RowsExceededException rowsExceededException) {
            rowsExceededException.printStackTrace();
        }
        catch (WriteException writeException) {
            writeException.printStackTrace();
        }
    }

    private void addDoubleToSheet(WritableSheet writableSheet, int n, int n2, double d, WritableCellFormat writableCellFormat) {
        try {
            if (d == -1.0) {
                return;
            }
            if (d == 0.0) {
                this.addLabelToSheet(writableSheet, n, n2, "?", null);
                return;
            }
            if (writableCellFormat == null) {
                writableSheet.addCell(new Number(n, n2, d));
            } else {
                writableSheet.addCell(new Number(n, n2, d, (CellFormat)writableCellFormat));
            }
        }
        catch (RowsExceededException rowsExceededException) {
            rowsExceededException.printStackTrace();
        }
        catch (WriteException writeException) {
            writeException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
    }
}

