/*
 * Decompiled with CFR 0.152.
 */
package org.expasy.bprg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import layout.SpringUtilities;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.expasy.bprg.AboutFrame;
import org.expasy.bprg.PeptideLabel;
import org.expasy.bprg.PeptideLabelModel;
import org.expasy.bprg.SilacQuanti;
import org.expasy.bprg.SilacQuantiParam;
import org.expasy.minitools.util.FileUtils;

public class MainFrame
extends JFrame {
    private String version = "MALDIPepQuant v3.1";
    private static Logger log = Logger.getLogger(MainFrame.class);
    private JFileChooser fc = new JFileChooser();
    private JTextField tfError;
    private JTable tbLabels;
    private JTextField tfExcelFile;
    private JTextField tfPAFiles;
    private String tfPAFilter;
    private JCheckBox cbMOneDa;
    private JCheckBox cbMTwoDa;
    private ButtonGroup groupIntermPeaks;
    private JRadioButton rbIntermPeaksNo;
    private JRadioButton rbIntermPeaksYes;
    private PeptideLabelModel peptideLabelModel;

    public MainFrame() throws HeadlessException {
        this.setTitle(this.version);
        this.setIconImage(null);
        this.setDefaultCloseOperation(3);
        this.createElements();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.height - 550) / 2;
        int n2 = (dimension.width - 500) / 2;
        this.setBounds(n2, n, 500, 550);
        this.setVisible(true);
        log.info("\nMainFrame constructed and visible\n");
    }

    private void createElements() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("?");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("About " + this.version);
        jMenuItem.getAccessibleContext().setAccessibleDescription("General informations on this program.");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutFrame aboutFrame = new AboutFrame(MainFrame.this.version);
                aboutFrame.setVisible(true);
            }
        });
        jMenu.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Error on peptide mass (Da) :");
        FileUtils.addConstraints(gridBagConstraints, 0, 0, 2, 1, 0.5, 0.1, 10, 5, 0, 21);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.tfError = new JTextField("0.2");
        jLabel.setLabelFor(this.tfError);
        FileUtils.addConstraints(gridBagConstraints, 3, 0, 1, 1, 0.5, 0.1, 10, 5, 2, 13);
        gridBagLayout.setConstraints(this.tfError, gridBagConstraints);
        jPanel2.add(this.tfError);
        JLabel jLabel2 = new JLabel("Used labels :");
        jLabel2.setBackground(Color.green);
        FileUtils.addConstraints(gridBagConstraints, 0, 1, 2, 1, 0.5, 0.1, 10, 5, 0, 21);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        this.peptideLabelModel = new PeptideLabelModel(true);
        this.peptideLabelModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                MainFrame.this.rbIntermPeaksYes.setEnabled(MainFrame.this.peptideLabelModel.getData().size() < 2);
                MainFrame.this.rbIntermPeaksNo.setEnabled(MainFrame.this.peptideLabelModel.getData().size() < 2);
            }
        });
        this.tbLabels = new JTable(this.peptideLabelModel);
        JScrollPane jScrollPane = new JScrollPane(this.tbLabels);
        FileUtils.addConstraints(gridBagConstraints, 2, 1, 2, 2, 0.5, 0.2, 10, 5, 1, 10);
        jLabel2.setLabelFor(this.tbLabels);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        JButton jButton = new JButton("Add...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmallForm smallForm = new SmallForm(MainFrame.this, "New Label");
                smallForm.pack();
                smallForm.setVisible(true);
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 0, 2, 1, 1, 0.25, 0.1, 10, 5, 0, 13);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = MainFrame.this.tbLabels.getSelectedRows();
                if (nArray.length == 0) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Empty selection!", "Selection error", 2);
                    return;
                }
                String string = "";
                int[] nArray2 = nArray;
                int n = nArray2.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    string = string + MainFrame.this.peptideLabelModel.getData().get(n2) + "\n";
                }
                int n3 = JOptionPane.showConfirmDialog(MainFrame.this, "Element(s) to remove:\n" + string + "Are you sure?", "Confirm deletion", 0);
                if (n3 == 0) {
                    for (n = nArray.length - 1; n >= 0; --n) {
                        MainFrame.this.peptideLabelModel.removeRow(nArray[n]);
                    }
                }
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 1, 2, 1, 1, 0.25, 0.1, 10, 5, 0, 13);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel2.add(jButton2);
        JLabel jLabel3 = new JLabel("Select files for data treatment");
        FileUtils.addConstraints(gridBagConstraints, 0, 3, 4, 1, 1.0, 0.1, 10, 5, 0, 10);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        JPanel jPanel3 = this.createFilePanel();
        FileUtils.addConstraints(gridBagConstraints, 0, 4, 4, 1, 1.0, 0.3, 10, 5, 2, 21);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JLabel jLabel4 = new JLabel("Find echo peaks at");
        FileUtils.addConstraints(gridBagConstraints, 0, 5, 2, 1, 0.5, 0.1, 10, 5, 0, 17);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel2.add(jLabel4);
        this.cbMOneDa = new JCheckBox("-1 Da");
        this.cbMOneDa.setSelected(true);
        this.cbMOneDa.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.this.cbMTwoDa.setEnabled(MainFrame.this.cbMOneDa.isSelected());
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 2, 5, 1, 1, 0.25, 0.1, 10, 5, 0, 10);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(this.cbMOneDa, gridBagConstraints);
        jPanel2.add(this.cbMOneDa);
        this.cbMTwoDa = new JCheckBox("-2 Da");
        FileUtils.addConstraints(gridBagConstraints, 3, 5, 1, 1, 0.25, 0.1, 10, 5, 0, 17);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(this.cbMTwoDa, gridBagConstraints);
        jPanel2.add(this.cbMTwoDa);
        JLabel jLabel5 = new JLabel("Find intermediary peaks");
        FileUtils.addConstraints(gridBagConstraints, 0, 6, 2, 1, 0.5, 0.1, 10, 5, 0, 17);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel2.add(jLabel5);
        this.rbIntermPeaksYes = new JRadioButton("Yes");
        this.rbIntermPeaksYes.setActionCommand("Yes");
        this.rbIntermPeaksYes.setSelected(true);
        this.rbIntermPeaksYes.setEnabled(this.peptideLabelModel.getData().size() < 2);
        FileUtils.addConstraints(gridBagConstraints, 2, 6, 1, 1, 0.25, 0.1, 10, 5, 0, 10);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(this.rbIntermPeaksYes, gridBagConstraints);
        jPanel2.add(this.rbIntermPeaksYes);
        this.rbIntermPeaksNo = new JRadioButton("No");
        this.rbIntermPeaksNo.setActionCommand("No");
        this.rbIntermPeaksNo.setEnabled(this.peptideLabelModel.getData().size() < 2);
        FileUtils.addConstraints(gridBagConstraints, 3, 6, 1, 1, 0.25, 0.1, 10, 5, 0, 17);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(this.rbIntermPeaksNo, gridBagConstraints);
        jPanel2.add(this.rbIntermPeaksNo);
        this.groupIntermPeaks = new ButtonGroup();
        this.groupIntermPeaks.add(this.rbIntermPeaksYes);
        this.groupIntermPeaks.add(this.rbIntermPeaksNo);
        JButton jButton3 = new JButton("Start...");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainFrame.this.runSilacQuanti();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MainFrame.this, exception.getMessage(), "Execution error", 0);
                    exception.printStackTrace();
                }
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 0, 7, 4, 1, 1.0, 0.1, 10, 5, 0, 13);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
    }

    protected void runSilacQuanti() {
        SilacQuantiParam silacQuantiParam;
        block9: {
            block8: {
                silacQuantiParam = new SilacQuantiParam();
                if (this.tfError.getText().equals("")) break block8;
                Double d = new Double(this.tfError.getText());
                if (!(d < 0.0)) break block9;
            }
            JOptionPane.showMessageDialog(this, "Error while checking Error : please enter a positive number.", "Parameter error", 0);
            return;
        }
        silacQuantiParam.error = new Double(this.tfError.getText());
        silacQuantiParam.data = this.peptideLabelModel.getData();
        if (silacQuantiParam.data.size() < 1) {
            JOptionPane.showMessageDialog(this, "Error while checking Label data :\n please provide at least one label.", "Parameter error", 0);
            return;
        }
        silacQuantiParam.findEchoPeaks = this.cbMOneDa.isSelected() ? 1 + (this.cbMTwoDa.isSelected() ? 1 : 0) : 0;
        boolean bl = silacQuantiParam.findIntermPeaks = this.rbIntermPeaksYes.isSelected() && silacQuantiParam.data.size() == 1;
        if (this.tfPAFiles.equals("")) {
            JOptionPane.showMessageDialog(this, "Error while checking Peak area files :\n please select one file containing peak areas\n (and put a # at the label position).", "Parameter error", 0);
            return;
        }
        silacQuantiParam.paFolder = new File(this.tfPAFiles.getText());
        if (this.tfPAFilter == null) {
            JOptionPane.showMessageDialog(this, "Error while checking Peak area file name :\n please select one file containing peak areas\n (and put a # at the label position).", "Parameter error", 0);
            return;
        }
        if (!this.tfPAFilter.contains("#")) {
            JOptionPane.showMessageDialog(this, "Error while checking Peak area file name :\n please put a # at the label position.", "Parameter error", 0);
            return;
        }
        silacQuantiParam.paFilter = this.tfPAFilter.substring(0, this.tfPAFilter.indexOf("#"));
        SilacQuanti silacQuanti = new SilacQuanti();
        File file = new File(this.tfExcelFile.getText());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "Error while checking Excel file :\n file does not exist.", "Parameter error", 0);
            return;
        }
        silacQuanti.quantifyAndWrite(file, silacQuantiParam);
    }

    private JPanel createFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setPreferredSize(new Dimension(300, 200));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Excel file :");
        FileUtils.addConstraints(gridBagConstraints, 0, 0, 2, 1, 1.0, 0.25, 10, 5, 0, 21);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.tfExcelFile = new JTextField("");
        jLabel.setLabelFor(this.tfExcelFile);
        FileUtils.addConstraints(gridBagConstraints, 0, 1, 1, 1, 0.75, 0.25, 10, 5, 2, 10);
        gridBagLayout.setConstraints(this.tfExcelFile, gridBagConstraints);
        jPanel.add(this.tfExcelFile);
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExcelFileFilter excelFileFilter = new ExcelFileFilter();
                MainFrame.this.fc.setFileFilter(excelFileFilter);
                int n = MainFrame.this.fc.showOpenDialog(MainFrame.this);
                if (n == 0) {
                    File file = MainFrame.this.fc.getSelectedFile();
                    try {
                        MainFrame.this.tfExcelFile.setText(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                MainFrame.this.fc.resetChoosableFileFilters();
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 1, 1, 1, 1, 0.25, 0.25, 10, 5, 0, 10);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        JLabel jLabel2 = new JLabel("Peak lists folder :");
        FileUtils.addConstraints(gridBagConstraints, 0, 2, 2, 1, 1.0, 0.25, 10, 5, 0, 21);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.tfPAFiles = new JTextField("");
        jLabel.setLabelFor(this.tfPAFiles);
        FileUtils.addConstraints(gridBagConstraints, 0, 3, 1, 1, 0.75, 0.25, 10, 5, 2, 10);
        gridBagLayout.setConstraints(this.tfPAFiles, gridBagConstraints);
        jPanel.add(this.tfPAFiles);
        JButton jButton2 = new JButton("Browse");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = MainFrame.this.fc.showOpenDialog(MainFrame.this);
                if (n == 0) {
                    File file = MainFrame.this.fc.getSelectedFile();
                    MainFrame.this.tfPAFiles.setText(file.getParent());
                    MainFrame.this.tfPAFilter = file.getName();
                }
            }
        });
        FileUtils.addConstraints(gridBagConstraints, 1, 3, 1, 1, 0.25, 0.25, 10, 5, 0, 10);
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException2) {
                unsupportedLookAndFeelException2.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PropertyConfigurator.configureAndWatch("H:/Work/Projects/bprg/MALDIPepQuant_multitags/lib/log4j/log4j.properties", 60000L);
        new MainFrame();
    }

    private class ExcelFileFilter
    extends FileFilter {
        private ExcelFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equals("xls");
            }
            return false;
        }

        public String getDescription() {
            return "Microsoft Excel files (.xls)";
        }

        public String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    private class SmallForm
    extends JDialog {
        public SmallForm(JFrame jFrame, String string) {
            super((Frame)jFrame, string);
            this.setDefaultCloseOperation(2);
            JPanel jPanel = new JPanel(new SpringLayout());
            jPanel.setOpaque(true);
            JLabel jLabel = new JLabel("Label text: ", 11);
            jPanel.add(jLabel);
            final JTextField jTextField = new JTextField("13C6/15N2-Lys", 10);
            jLabel.setLabelFor(jTextField);
            jPanel.add(jTextField);
            JLabel jLabel2 = new JLabel("Shift: ", 11);
            jPanel.add(jLabel2);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel((Number)8, Integer.valueOf(1), null, (Number)1);
            final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
            jLabel2.setLabelFor(jSpinner);
            jPanel.add(jSpinner);
            JLabel jLabel3 = new JLabel("Amino acid: ", 11);
            jPanel.add(jLabel3);
            final JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "Y"});
            jComboBox.setSelectedIndex(8);
            jLabel3.setLabelFor(jComboBox);
            jPanel.add(jComboBox);
            SpringUtilities.makeCompactGrid(jPanel, 3, 2, 6, 6, 6, 6);
            jPanel.setAlignmentX(0.5f);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 3));
            jPanel2.add(jPanel);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTextField.getText().equals("")) {
                        return;
                    }
                    PeptideLabel peptideLabel = new PeptideLabel(jTextField.getText(), (Integer)jSpinner.getValue(), jComboBox.getSelectedItem().toString());
                    MainFrame.this.peptideLabelModel.addData(peptideLabel);
                    SmallForm.this.setVisible(false);
                    SmallForm.this.dispose();
                }
            });
            jButton.setAlignmentX(0.5f);
            jPanel2.add(jButton);
            jPanel2.setOpaque(true);
            this.setContentPane(jPanel2);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.height - 250) / 2;
            int n2 = (dimension.width - 250) / 2;
            this.setBounds(n2, n, 250, 250);
        }
    }
}

