/*
 * Decompiled with CFR 0.152.
 */
package org.expasy.bprg;

import java.util.Arrays;
import java.util.HashMap;
import jxl.Cell;
import jxl.NumberCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhenyxSILACPeptide {
    private String proteinName;
    private String peptideString;
    private double peptideMass;
    private String modifications;
    private String description;

    public PhenyxSILACPeptide(Cell[] cellArray) {
        this.proteinName = cellArray[1].getContents();
        this.peptideString = cellArray[2].getContents();
        this.peptideMass = ((NumberCell)cellArray[7]).getValue();
        this.modifications = cellArray[8].getContents();
        this.description = cellArray[9].getContents();
    }

    public boolean isLabeledWith(String string) {
        return this.modifications.indexOf(string) != -1;
    }

    public boolean[] isLabeledWith(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            blArray[n] = this.modifications.indexOf(string) != -1;
            ++n;
        }
        return blArray;
    }

    public int getAACount(char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            for (int j = 0; j < this.peptideString.length(); ++j) {
                if (this.peptideString.charAt(j) != c) continue;
                ++n;
            }
        }
        return n;
    }

    public int[] getAACounts(char[] cArray) {
        int[] nArray = new int[cArray.length];
        Arrays.fill(nArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            for (int j = 0; j < this.peptideString.length(); ++j) {
                if (this.peptideString.charAt(j) != c) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    public int getAAPresent(char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (!this.peptideString.contains("" + cArray[i])) continue;
            ++n;
        }
        return n;
    }

    public String getSpectrumId() {
        return this.description.substring(7, this.description.indexOf(44));
    }

    public String getSpectrumLabel() {
        return this.description.substring(0, this.description.indexOf(44));
    }

    public Iterable<String> getModifsExcept(String string) {
        String[] stringArray;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String string2 : stringArray = this.modifications.split(":")) {
            hashMap.put(string2, Boolean.TRUE);
        }
        hashMap.remove(string);
        hashMap.remove("");
        return hashMap.keySet();
    }

    public Iterable<String> getModifsExcept(String[] stringArray) {
        String[] stringArray2;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String string : stringArray2 = this.modifications.split(":")) {
            hashMap.put(string, Boolean.TRUE);
        }
        for (String string : stringArray) {
            hashMap.remove(string);
        }
        hashMap.remove("");
        return hashMap.keySet();
    }

    public String getDescription() {
        return this.description;
    }

    public double getPeptideMass() {
        return this.peptideMass;
    }

    public String getPeptideString() {
        return this.peptideString;
    }

    public String getProteinName() {
        return this.proteinName;
    }
}

