package org.expasy.bprg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

/**
 * A simple Frame aimed at displaying varous informations about the software.
 * @author chernand
 *
 */
public class AboutFrame extends JFrame {

    /**
     * Constructor of the Frame.
     *
     * @param version String version of the software.
     */
    public AboutFrame(String version) {
        super();
        setTitle("About MALDIPepQuant...");

        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        this.createElements(version);

        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = (screenSize.height - 250) / 2;
        int x = (screenSize.width - 250) / 2;
        this.setBounds(x, y, 250, 250);
    }

    /**
     *
     */
    private void createElements(String version) {
        JPanel generalPanel = new JPanel();
        //generalPanel.setBackground(Color.white);
        generalPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        BoxLayout layout = new BoxLayout(generalPanel, BoxLayout.Y_AXIS);
        generalPanel.setLayout(layout);

        //////////////////////////////PANEL
        JPanel paramPanel = new JPanel();
        paramPanel.setBackground(Color.white);
        paramPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        BoxLayout layout2 = new BoxLayout(paramPanel, BoxLayout.Y_AXIS);
        paramPanel.setLayout(layout2);

        ////////
        JLabel lbVersionLbl = new JLabel("<html><font size=+1><i>Version :</i></font></html>");
        lbVersionLbl.setAlignmentX(0.5f);
        paramPanel.add(lbVersionLbl);
        JLabel lbVersion = new JLabel(version);
        lbVersion.setAlignmentX(0.5f);
        paramPanel.add(lbVersion);
        JLabel lbDateLbl = new JLabel("<html><font size=+1><i>Date :</i></font></html>");
        lbDateLbl.setAlignmentX(0.5f);
        paramPanel.add(lbDateLbl);
        JLabel lbDate = new JLabel("08/11/2007");
        lbDate.setAlignmentX(0.5f);
        paramPanel.add(lbDate);
        JLabel lbContactLbl = new JLabel("<html><font size=+1><i>Contact :</i></font></html>");
        lbContactLbl.setAlignmentX(0.5f);
        paramPanel.add(lbContactLbl);
        JLabel lbContact = new JLabel("tools@expasy.org");
        lbContact.setAlignmentX(0.5f);
        paramPanel.add(lbContact);

        generalPanel.add(paramPanel);

        generalPanel.add(Box.createVerticalGlue());
        JButton buttonOK = new JButton("OK");
        buttonOK.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                AboutFrame.this.dispose();
            }

        });
        buttonOK.setAlignmentX(0.5f);
        generalPanel.add(buttonOK);

        add(generalPanel, BorderLayout.CENTER);
    }

     /////////////////////////////////////////////////////

    /**
     * Test this frame independently.
     */
    public static void main(String[] args) {
        AboutFrame frame = new AboutFrame("Unknown");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

}
