/**
 *
 */
package org.expasy.bprg;

import java.util.Arrays;
import java.util.HashMap;

import jxl.Cell;
import jxl.NumberCell;

/**
 * @author chernand
 *
 */
public class PhenyxSILACPeptide {

    private String proteinName;
    private String peptideString;
    private double peptideMass;
    private String modifications;
    private String description;


    /**
     *
     */
    public PhenyxSILACPeptide(Cell[] identRowData) {
        proteinName = identRowData[1].getContents();
        peptideString = identRowData[2].getContents();
        peptideMass = ((NumberCell)identRowData[7]).getValue();//can't use getContents because of all differents number formats
        modifications = identRowData[8].getContents();
        description = identRowData[9].getContents();
    }



    public boolean isLabeledWith(String label) {
        return (modifications.indexOf(label) != -1);
    }

    public boolean[] isLabeledWith(String[] labels) {
        boolean[] labelThere = new boolean[labels.length];
        int i=0;
        for (String oneLabel : labels) {
            labelThere[i] = (modifications.indexOf(oneLabel) != -1);
            i++;
        }
        return labelThere;
    }

    
    public int getAACount(char[] labels) {
        //TODO use code point count?
        int aaCounter = 0;
        for(int i=0; i<labels.length; i++) {
            char aa = labels[i];
            for(int j=0; j<peptideString.length();j++) {
                if(peptideString.charAt(j) == aa) aaCounter++;
            }
        
        }
        return aaCounter;
    }

    public int[] getAACounts(char[] labels) {
        int[] aaCounters = new int[labels.length];
        Arrays.fill(aaCounters, 0);
        for(int i=0; i<labels.length; i++) {
            char aa = labels[i];
            for(int j=0; j<peptideString.length();j++) {
                if(peptideString.charAt(j) == aa) aaCounters[i]++;
            }
        
        }
        return aaCounters;
    }
    public int getAAPresent(char[] labels) {
        int aaCounter = 0;
        for(int i=0; i<labels.length; i++) {
            if( peptideString.contains(""+labels[i]) ) 
                aaCounter++;
        }
        return aaCounter;
    }

    
    public String getSpectrumId() {
        return description.substring(7, description.indexOf(','));
    }

    public String getSpectrumLabel() {
        return description.substring(0, description.indexOf(','));
    }

    /**
     * @param modifsCell
     * @return
     */
    public Iterable<String> getModifsExcept(String exceptedLabel) {
        HashMap<String, Boolean> hModifs = new HashMap<String, Boolean>();

        String[] matches = modifications.split(":");
        for (String modif : matches) {
            hModifs.put(modif, Boolean.TRUE);
        }
        //Label we are searching for won't be contained inside the output list
        hModifs.remove(exceptedLabel);
        //empty string neither
        hModifs.remove("");

        return hModifs.keySet();
    }

    /**
     * @param modifsCell
     * @return
     */
    public Iterable<String> getModifsExcept(String[] exceptedLabels) {
        HashMap<String, Boolean> hModifs = new HashMap<String, Boolean>();

        String[] matches = modifications.split(":");
        for (String modif : matches) {
            hModifs.put(modif, Boolean.TRUE);
        }
        //Label we are searching for won't be contained inside the output list
        for (String exceptedLabel : exceptedLabels) {
            hModifs.remove(exceptedLabel);
        }
        //empty string neither
        hModifs.remove("");

        return hModifs.keySet();
    }



    //Accessors///////////////////////////////////////////////////////


    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }



    /**
     * @return the peptideMass
     */
    public double getPeptideMass() {
        return peptideMass;
    }



    /**
     * @return the peptideString
     */
    public String getPeptideString() {
        return peptideString;
    }



    /**
     * @return the proteinName
     */
    public String getProteinName() {
        return proteinName;
    }

}
