\encoding{UTF-8}
\name{ci}
\alias{ci}
\alias{ci.default}
\alias{ci.formula}
\alias{ci.roc}
\alias{ci.smooth.roc}

\title{
  Compute the confidence interval of a ROC curve
}
\description{
  This function computes the confidence interval (CI) of a ROC curve. The
  \code{of} argument controls the type of CI that will be computed.
  By default, the 95\% CI are computed with 2000 stratified bootstrap
  replicates.
}
\usage{
ci(x, ...)
\S3method{ci}{roc}(roc, of = c("auc", "thresholds", "sp", "se"), ...)
\S3method{ci}{smooth.roc}(smooth.roc, of = c("auc", "sp", "se"), ...)
\S3method{ci}{formula}(formula, data, ...)
\S3method{ci}{default}(response, predictor, ...)
}
		   
\arguments{
  \item{x}{a roc object from the \link{roc} function (for ci.roc),
    a formula (for ci.formula) or a response vector (for
    ci.default).
  }
  \item{roc, smooth.roc}{a \dQuote{roc} object from the
	\code{\link{roc}} function, or a \dQuote{smooth.roc} object from the
	\code{\link{smooth.roc}} function.
  }
  \item{response, predictor}{arguments for the \code{\link{roc}} function.}
  \item{formula, data}{a formula (and possibly a data object) of type
	response~predictor for the \code{\link{roc}} function.
  }
  \item{of}{The type of confidence interval. One of \dQuote{auc},
	\dQuote{thresholds}, \dQuote{sp} or \dQuote{se}. Note that
	confidence interval on \dQuote{thresholds} are not available for
	smoothed ROC curves.
  }
  \item{\dots}{further arguments passed to or from other methods,
    especially \code{\link{auc}}, \code{\link{roc}}, and the specific
	\code{ci} functions \code{\link{ci.auc}}, \code{\link{ci.se}},
	\code{\link{ci.sp}} and \code{\link{ci.thresholds}}.
  }
}

\details{
  \code{ci.formula} and \code{ci.default} are convenience methods
  that build the ROC curve (with the \code{\link{roc}} function) before
  calling \code{ci.roc}. You can pass them arguments for both
  \code{\link{roc}} and \code{ci.roc}. Simply use \code{ci}
  that will dispatch to the correct method.
  
  This function is typically called from \code{\link{roc}} when \code{ci=TRUE} (not by
  default). Depending on the \code{of} argument, the specific
  \code{ci} functions \code{\link{ci.auc}}, \code{\link{ci.thresholds}},
  \code{\link{ci.sp}} or \code{\link{ci.se}} are called.
}

\value{
The return value of the specific \code{ci} functions
\code{\link{ci.auc}}, \code{\link{ci.thresholds}}, \code{\link{ci.sp}}
or \code{\link{ci.se}}, depending on the
\code{of} argument.
}

\seealso{
  \code{\link{roc}}, \code{\link{auc}}, \code{\link{ci.auc}},
  \code{\link{ci.thresholds}}, \code{\link{ci.sp}}, \code{\link{ci.se}}
}

\examples{
data(aSAH)

# Syntax (response, predictor):
ci(aSAH$outcome, aSAH$s100b)

# With a roc object:
rocobj <- roc(aSAH$outcome, aSAH$s100b)

# Of an AUC 
ci(rocobj)
ci(rocobj, of="auc")
# this is strictly equivalent to:
ci.auc(rocobj)

# Of thresholds, sp, se...
ci(rocobj, of="thresholds")
ci(rocobj, of="thresholds", thresholds=0.51)
ci(rocobj, of="thresholds", thresholds="all")
ci(rocobj, of="sp", sensitivities=c(.95, .9, .85))
ci(rocobj, of="se")

# Alternatively, you can get the CI directly from roc():
rocobj <- roc(aSAH$outcome,
              aSAH$s100b, ci=TRUE, of="auc")
rocobj$ci

}

\keyword{univar}
\keyword{nonparametric}
\keyword{utilities}
\keyword{roc}
